﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Net.Sockets;

namespace CS_iSMS_Tester
{
    class smsTCP
    {
        // This function sends a message using TCP to the IP address/port provided.
        public String SendTCPMessage(String IPAddress, int Port, String message)
        {
            try
            {
                // Create a TcpClient.
                TcpClient client = new TcpClient(IPAddress, Port);
                
                // Translate the passed message into ASCII and store it as a Byte array.
                Byte[] data = System.Text.Encoding.ASCII.GetBytes(message);
                                
                // Get a client stream for reading and writing.
                NetworkStream stream = client.GetStream();

                // Send the message to the connected TcpServer. 
                stream.Write(data, 0, data.Length);
                
                // Receive the TcpServer.response.
                // Buffer to store the response bytes.
                data = new Byte[256];

                // String to store the response ASCII representation.
                String responseData = String.Empty;

                // Read the first batch of the TcpServer response bytes.
                Int32 bytes = stream.Read(data, 0, data.Length);
                responseData = System.Text.Encoding.ASCII.GetString(data, 0, bytes);
                                
                // Close everything.
                client.Close();

                return responseData;
            }
            catch (ArgumentNullException e)
            {   // Send back error description
                return e.ToString();
            }
            catch (SocketException e)
            {   // Send back error description
                return e.ToString();
            }
                      
        }
    }
}
